/*
 * Decompiled with CFR 0.152.
 */
package com.sdk.douyou.util.ball;

import android.content.Context;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;

public class ShakeListener
implements SensorEventListener {
    public static ShakeListener sensor1;
    private static final int SPEED_SHRESHOLD = 400;
    private static final int UPTATE_INTERVAL_TIME = 70;
    private SensorManager sensorManager;
    private Sensor sensor;
    private OnShakeListener onShakeListener;
    private static Context context;
    private float lastX;
    private float lastY;
    private float lastZ;
    private long lastUpdateTime;

    public static ShakeListener newInstance(Context c) {
        if (sensor1 == null) {
            sensor1 = new ShakeListener();
            context = c;
            return sensor1;
        }
        return sensor1;
    }

    public void start() {
        if (this.sensorManager == null) {
            this.sensorManager = (SensorManager)context.getSystemService("sensor");
        }
        if (this.sensorManager != null && this.sensor == null) {
            this.sensor = this.sensorManager.getDefaultSensor(1);
        }
        if (this.sensor != null) {
            this.sensorManager.registerListener((SensorEventListener)this, this.sensor, 3);
        }
    }

    public void stop() {
        this.sensorManager.unregisterListener((SensorEventListener)this);
    }

    public void setOnShakeListener(OnShakeListener listener) {
        this.onShakeListener = listener;
    }

    public void onSensorChanged(SensorEvent event) {
        long currentUpdateTime = System.currentTimeMillis();
        long timeInterval = currentUpdateTime - this.lastUpdateTime;
        if (timeInterval < 70L) {
            return;
        }
        this.lastUpdateTime = currentUpdateTime;
        float x = event.values[0];
        float y = event.values[1];
        float z = event.values[2];
        float deltaX = x - this.lastX;
        float deltaY = y - this.lastY;
        float deltaZ = z - this.lastZ;
        this.lastX = x;
        this.lastY = y;
        this.lastZ = z;
        double speed = Math.sqrt(deltaX * deltaX + deltaY * deltaY + deltaZ * deltaZ) / (double)timeInterval * 10000.0;
        if (speed >= 400.0) {
            this.onShakeListener.onShake();
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }

    public static interface OnShakeListener {
        public void onShake();
    }
}

