/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.vasdolly.common;

import com.tencent.vasdolly.common.ChannelConstants;
import com.tencent.vasdolly.common.Pair;
import com.tencent.vasdolly.common.verify.ApkSignatureSchemeV2Verifier;
import com.tencent.vasdolly.common.verify.ZipUtils;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class V1SchemeUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeChannel(File file, String channel) throws Exception {
        if (file == null || !file.exists() || !file.isFile() || channel == null || channel.isEmpty()) {
            throw new Exception("param error , file : " + file + " , channel : " + channel);
        }
        RandomAccessFile raf = null;
        byte[] comment = channel.getBytes("UTF-8");
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = V1SchemeUtil.getEocd(file);
        if (eocdAndOffsetInFile.getFirst().remaining() == 22) {
            System.out.println("file : " + file.getAbsolutePath() + " , has no comment");
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(file.length() - 2L);
                V1SchemeUtil.writeShort(comment.length + 2 + ChannelConstants.V1_MAGIC.length, raf);
                raf.write(comment);
                V1SchemeUtil.writeShort(comment.length, raf);
                raf.write(ChannelConstants.V1_MAGIC);
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
        System.out.println("file : " + file.getAbsolutePath() + " , has comment");
        if (V1SchemeUtil.containV1Magic(file)) {
            try {
                String existChannel = V1SchemeUtil.readChannel(file);
                if (existChannel != null) {
                    file.delete();
                    throw new ChannelExistException("file : " + file.getAbsolutePath() + " has a channel : " + existChannel + ", only ignore");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        int existCommentLength = ZipUtils.getUnsignedInt16(eocdAndOffsetInFile.getFirst(), 20);
        int newCommentLength = existCommentLength + comment.length + 2 + ChannelConstants.V1_MAGIC.length;
        try {
            raf = new RandomAccessFile(file, "rw");
            raf.seek(eocdAndOffsetInFile.getSecond() + 22L - 2L);
            V1SchemeUtil.writeShort(newCommentLength, raf);
            raf.seek(eocdAndOffsetInFile.getSecond() + 22L + (long)existCommentLength);
            raf.write(comment);
            V1SchemeUtil.writeShort(comment.length, raf);
            raf.write(ChannelConstants.V1_MAGIC);
        }
        finally {
            if (raf != null) {
                raf.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeChannelByV1(File file) throws Exception {
        if (file == null || !file.exists() || !file.isFile()) {
            throw new Exception("param error , file : " + file);
        }
        RandomAccessFile raf = null;
        Pair<ByteBuffer, Long> eocdAndOffsetInFile = V1SchemeUtil.getEocd(file);
        if (eocdAndOffsetInFile.getFirst().remaining() == 22) {
            System.out.println("file : " + file.getName() + " , has no comment");
        } else {
            System.out.println("file : " + file.getName() + " , has comment");
            int existCommentLength = ZipUtils.getUnsignedInt16(eocdAndOffsetInFile.getFirst(), 20);
            try {
                raf = new RandomAccessFile(file, "rw");
                raf.seek(eocdAndOffsetInFile.getSecond() + 22L - 2L);
                V1SchemeUtil.writeShort(0, raf);
                raf.setLength(file.length() - (long)existCommentLength);
                System.out.println("file : " + file.getName() + " , remove comment success");
            }
            finally {
                if (raf != null) {
                    raf.close();
                }
            }
        }
    }

    public static String readChannel(File file) throws Exception {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file, "r");
            long index = raf.length();
            byte[] buffer = new byte[ChannelConstants.V1_MAGIC.length];
            raf.seek(index -= (long)ChannelConstants.V1_MAGIC.length);
            raf.readFully(buffer);
            if (V1SchemeUtil.isV1MagicMatch(buffer)) {
                raf.seek(index -= 2L);
                short length = V1SchemeUtil.readShort(raf);
                if (length > 0) {
                    raf.seek(index -= (long)length);
                    byte[] bytesComment = new byte[length];
                    raf.readFully(bytesComment);
                    String string = new String(bytesComment, "UTF-8");
                    return string;
                }
                throw new Exception("zip channel info not found");
            }
            throw new Exception("zip v1 magic not found");
        }
    }

    private static void writeShort(int i, DataOutput out) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(2).order(ByteOrder.LITTLE_ENDIAN);
        bb.putShort((short)i);
        out.write(bb.array());
    }

    private static short readShort(DataInput input) throws IOException {
        byte[] buf = new byte[2];
        input.readFully(buf);
        ByteBuffer bb = ByteBuffer.wrap(buf).order(ByteOrder.LITTLE_ENDIAN);
        return bb.getShort(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean containV1Magic(File file) throws IOException {
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(file, "r");
            long index = raf.length();
            byte[] buffer = new byte[ChannelConstants.V1_MAGIC.length];
            raf.seek(index -= (long)ChannelConstants.V1_MAGIC.length);
            raf.readFully(buffer);
            boolean bl = V1SchemeUtil.isV1MagicMatch(buffer);
            return bl;
        }
    }

    private static boolean isV1MagicMatch(byte[] buffer) {
        if (buffer.length != ChannelConstants.V1_MAGIC.length) {
            return false;
        }
        for (int i = 0; i < ChannelConstants.V1_MAGIC.length; ++i) {
            if (buffer[i] == ChannelConstants.V1_MAGIC[i]) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Pair<ByteBuffer, Long> getEocd(File apk) throws IOException, ApkSignatureSchemeV2Verifier.SignatureNotFoundException {
        if (apk == null || !apk.exists() || !apk.isFile()) {
            return null;
        }
        try (RandomAccessFile raf = null;){
            raf = new RandomAccessFile(apk, "r");
            Pair<ByteBuffer, Long> eocdAndOffsetInFile = ApkSignatureSchemeV2Verifier.getEocd(raf);
            if (ZipUtils.isZip64EndOfCentralDirectoryLocatorPresent(raf, eocdAndOffsetInFile.getSecond())) {
                throw new ApkSignatureSchemeV2Verifier.SignatureNotFoundException("ZIP64 APK not supported");
            }
            Pair<ByteBuffer, Long> pair = eocdAndOffsetInFile;
            return pair;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copyFile(File src, File dest) throws IOException {
        if (!dest.exists()) {
            dest.createNewFile();
        }
        FileChannel source = null;
        AbstractInterruptibleChannel destination = null;
        try {
            source = new FileInputStream(src).getChannel();
            destination = new FileOutputStream(dest).getChannel();
            ((FileChannel)destination).transferFrom(source, 0L, source.size());
        }
        finally {
            if (source != null) {
                source.close();
            }
            if (destination != null) {
                destination.close();
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean containV1Signature(File file) {
        try (JarFile jarFile = new JarFile(file);){
            JarEntry manifestEntry = jarFile.getJarEntry("META-INF/MANIFEST.MF");
            JarEntry sfEntry = null;
            Enumeration<JarEntry> entries = jarFile.entries();
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                if (!entry.getName().matches("META-INF/\\w+\\.SF")) continue;
                sfEntry = jarFile.getJarEntry(entry.getName());
                break;
            }
            jarFile.close();
            if (manifestEntry == null) return false;
            if (sfEntry == null) return false;
            boolean bl = true;
            return bl;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return false;
    }

    public static class ChannelExistException
    extends Exception {
        static final long serialVersionUID = -3387516993124229949L;

        public ChannelExistException() {
        }

        public ChannelExistException(String message) {
            super(message);
        }
    }
}

