/*
 * Decompiled with CFR 0.152.
 */
package com.taptapshare;

import android.app.Activity;
import android.content.Intent;
import android.net.Uri;
import com.taptapshare.TapTapShareBuilder;
import com.taptapshare.TapTapShareUtil;
import java.util.ArrayList;

public class TapTapShare {
    private TapTapShareBuilder builder;

    public TapTapShare(TapTapShareBuilder builder) {
        this.builder = builder;
    }

    public int share(Activity activity) {
        int code = this.verifyEnv(activity);
        if (code != 0) {
            Uri uri;
            if (this.builder.getFailUrl() != null) {
                uri = Uri.parse((String)this.builder.getFailUrl());
            } else {
                String url = "https://m.taptap.cn/app/" + this.builder.getAppId() + "/?utm_medium=rep&utm_source=rep_share_sdk_" + this.builder.getAppId();
                uri = Uri.parse((String)url);
            }
            Intent intent = new Intent("android.intent.action.VIEW", uri);
            activity.startActivity(intent);
            return code;
        }
        Intent shareIntent = new Intent();
        shareIntent.setAction("android.intent.action.SEND_MULTIPLE");
        shareIntent.setPackage("com.taptap");
        if (this.builder != null) {
            shareIntent.putExtra("android.intent.extra.TEXT", this.builder.getTapParamsString());
            this.checkUri(activity, this.builder.getImageUris());
            shareIntent.putParcelableArrayListExtra("android.intent.extra.STREAM", this.builder.getImageUris());
        }
        shareIntent.setType("image/*");
        activity.startActivity(shareIntent);
        return 0;
    }

    private void checkUri(Activity activity, ArrayList<Uri> imageUris) {
        if (imageUris == null) {
            return;
        }
        for (Uri uri : imageUris) {
            activity.grantUriPermission("com.taptap", uri, 1);
        }
    }

    private int verifyEnv(Activity activity) {
        if (!TapTapShareUtil.checkTapTapInstall(activity)) {
            return -1;
        }
        if (!TapTapShareUtil.checkTapTapSupportShare(activity)) {
            return -2;
        }
        return 0;
    }
}

