/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.convert;

import android.content.Context;
import android.text.TextUtils;
import com.bytedance.applog.convert.IIdProvider;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Locale;
import org.json.JSONException;
import org.json.JSONObject;

public class IPIDProvider
implements IIdProvider {
    @Override
    public void getIdAndSetIntoJson(JSONObject info, Context context) throws JSONException {
        String clickTunStr = null;
        try {
            clickTunStr = this.getClientTun();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)clickTunStr)) {
            info.put("client_tun", (Object)clickTunStr);
        }
        String clickAnpiStr = null;
        try {
            clickAnpiStr = this.getClientAnpi();
        }
        catch (SocketException e) {
            e.printStackTrace();
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
        }
        if (!TextUtils.isEmpty((CharSequence)clickAnpiStr)) {
            info.put("client_anpi", (Object)clickAnpiStr);
        }
    }

    public String getClientTun() throws SocketException {
        String clickTunStr = "";
        NetworkInterface dummy0 = NetworkInterface.getByName("dummy0");
        String dummy0Addr = "empty";
        if (dummy0 != null) {
            dummy0Addr = IPIDProvider.getLocalIpv6Address(dummy0.getInetAddresses()).toLowerCase(Locale.getDefault());
        }
        if (dummy0Addr.startsWith("fe80")) {
            clickTunStr = dummy0Addr;
        }
        return clickTunStr;
    }

    public String getClientAnpi() throws SocketException, UnknownHostException {
        String clickAnpiStr = "";
        String wlan0Addr = "empty";
        NetworkInterface wlan0 = NetworkInterface.getByName("wlan0");
        if (wlan0 != null && (wlan0Addr = IPIDProvider.getLocalIpv6Address(wlan0.getInetAddresses()).toLowerCase(Locale.getDefault())).startsWith("fe80")) {
            clickAnpiStr = wlan0Addr;
        }
        return clickAnpiStr;
    }

    public static String getLocalIpv6Address(Enumeration<InetAddress> list) {
        String res = "empty";
        if (list == null) {
            return res;
        }
        while (list.hasMoreElements()) {
            InetAddress address = list.nextElement();
            if (!(address instanceof Inet6Address) || !address.isLinkLocalAddress()) continue;
            res = address.getHostAddress();
        }
        return res;
    }
}

