/*
 * Decompiled with CFR 0.152.
 */
package com.douyou.advert.channel;

import android.app.Activity;
import android.content.Context;
import android.util.Log;
import com.qq.gdt.action.ActionUtils;
import com.qq.gdt.action.GDTAction;
import com.qq.gdt.action.PrivateController;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.bean.RoleInfoBean;
import com.sdk.douyou.data.DouYouDataCollection;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.util.DeviceUtil;
import com.sdk.douyou.util.DouYouSDKTools;
import com.sdk.douyou.util.net.BaLeApi;
import com.sdk.douyou.util.net.DouYouPostAsyncTask;

public class GdtManagement {
    private Activity activity;
    private String APPID;
    private String APPName;
    private String Channel;
    private static GdtManagement instance;

    public static GdtManagement getInstance() {
        if (instance == null) {
            instance = new GdtManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.activity = context;
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        Log.d((String)"DouYou", (String)("gdt-APPID: " + this.APPID));
        Log.d((String)"DouYou", (String)("gdt-APPName: " + this.APPName));
        Log.d((String)"DouYou", (String)("gdt-Channel: " + this.Channel));
    }

    private void init(Activity context) {
        Log.d((String)"DouYou", (String)"gdt- sdk-V1.8.8 init: start ");
        GDTAction.init((Context)this.activity, (String)this.APPID, (String)this.APPName, (String)this.Channel);
        GDTAction.setPrivateController((PrivateController)new PrivateController(){

            public boolean isCanUsePhoneState() {
                return false;
            }

            public String getDevImei() {
                return DeviceUtil.getAndroidId((Context)GdtManagement.this.activity);
            }
        });
        GDTAction.logAction((String)"START_APP");
        Log.d((String)"DouYou", (String)"gdt-  sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        Log.d((String)"DouYou", (String)"gdt- pay success");
                        GdtManagement.this.purchase(params, true);
                        Log.d((String)"DouYou", (String)"gdt- pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 41: {
                        Log.d((String)"DouYou", (String)"gdt- extra data");
                        GdtManagement.this.setUpdateLevel(DouYouDataCollection.getInstance().getRoleInfoBean());
                        Log.d((String)"DouYou", (String)"gdt- extra data");
                        break;
                    }
                    case 39: {
                        Log.d((String)"DouYou", (String)"gdt- register success");
                        GdtManagement.this.setRegister("wechat", true);
                        Log.d((String)"DouYou", (String)"gdt- register success");
                    }
                }
            }
        });
    }

    private void setRegister(String method, boolean is_success) {
        ActionUtils.onRegister((String)"bale", (boolean)true);
    }

    private void purchase(OrderInfoBean params, boolean is_success) {
        String report_money_str = params.getTrue_money();
        float report_money = Double.valueOf(report_money_str).floatValue();
        Log.d((String)"DouYou", (String)("report_money=" + report_money));
        ActionUtils.onPurchase((String)params.getProductName(), (String)params.getProductName(), (String)params.getProductName(), (int)1, (String)"\u652f\u4ed8", (String)"CNY", (int)((int)(report_money * 100.0f)), (boolean)true);
    }

    private void setUpdateLevel(RoleInfoBean data) {
        Log.d((String)"DouYou", (String)"gdt- setUpdateLevel");
        Log.d((String)"DouYou", (String)("gdt- dataType: " + data.getType()));
        if (data.getType() == 0) {
            return;
        }
        if (data.getType() == 2) {
            ActionUtils.onCreateRole((String)data.getNickname());
        } else if (data.getType() == 3) {
            ActionUtils.onUpdateLevel((int)Integer.parseInt(data.getLevel()));
        }
        BaLeApi.getInstance().channelReport("3", "", DouYou.getInstance().getAdId(), new DouYouPostAsyncTask.HttpGetDataListener(){

            public void getData(String returnData) {
            }

            public void Fail(String error) {
                Log.d((String)"DouYou", (String)error);
            }
        });
    }
}

