/*
 * Decompiled with CFR 0.152.
 */
package com.douyou.advert.channel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import com.kwai.monitor.log.TurboAgent;
import com.kwai.monitor.log.TurboConfig;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.listen.DouyouActivityCallback;
import com.sdk.douyou.util.DouYouSDKTools;

public class KuaiShouManagement {
    private Activity activity;
    private String APPID;
    private String APPName;
    private String Channel;
    private static KuaiShouManagement instance;

    public static KuaiShouManagement getInstance() {
        if (instance == null) {
            instance = new KuaiShouManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.activity = context;
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        Log.d((String)"DouYou", (String)("kuaishou-APPID: " + this.APPID));
        Log.d((String)"DouYou", (String)("kuaishou-APPName: " + this.APPName));
        Log.d((String)"DouYou", (String)("kuaishou-Channel: " + this.Channel));
    }

    private void init(Activity context) {
        Log.d((String)"DouYou", (String)"kuaishou- sdk-V1.0.14 init: start ");
        TurboAgent.init((TurboConfig)TurboConfig.TurboConfigBuilder.create((Context)context).setAppId(this.APPID).setAppName(this.APPName).setAppChannel(this.Channel).setEnableDebug(true).build());
        TurboAgent.onAppActive();
        Log.d((String)"DouYou", (String)"kuaishou-  sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        Log.d((String)"DouYou", (String)"kuaishou- pay success");
                        KuaiShouManagement.this.purchase(params, true);
                        Log.d((String)"DouYou", (String)"kuaishou- pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 39: {
                        Log.d((String)"DouYou", (String)"kuaishou- register success");
                        KuaiShouManagement.this.setRegister("wechat", true);
                        Log.d((String)"DouYou", (String)"kuaishou- toutiao register success");
                    }
                }
            }
        });
        DouYou.getInstance().setActivityCallback(new DouyouActivityCallback(){

            public void onCreate(Bundle savedInstanceState) {
            }

            public void onStart() {
            }

            public void onPause() {
                Log.d((String)"DouYou", (String)"kuaishou- onPause: ");
                TurboAgent.onPagePause();
            }

            public void onResume() {
                Log.d((String)"DouYou", (String)"kuaishou- onResume: ");
                TurboAgent.onPageResume();
            }

            public void onStop() {
            }

            public void onDestroy() {
            }

            public void onRestart() {
            }

            public void onBackPressed() {
            }

            public void onNewIntent(Intent newIntent) {
            }

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onSaveInstanceState(Bundle paramBundle) {
            }

            public void onActivityResult(int requestCode, int resultCode, Intent data) {
            }

            public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onWindowFocusChanged(boolean paramBoolean) {
            }
        });
    }

    private void setRegister(String method, boolean is_success) {
        TurboAgent.onRegister();
    }

    private void purchase(OrderInfoBean params, boolean is_success) {
        Log.d((String)"DouYou", (String)("report_money=" + Double.valueOf(params.getTrue_money()).floatValue()));
        TurboAgent.onPay((double)Double.valueOf(params.getTrue_money()).floatValue());
    }
}

