/*
 * Decompiled with CFR 0.152.
 */
package com.douyou.advert.channel;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.Configuration;
import android.os.Bundle;
import android.util.Log;
import com.bytedance.applog.AppLog;
import com.bytedance.applog.ILogger;
import com.bytedance.applog.IOaidObserver;
import com.bytedance.applog.InitConfig;
import com.bytedance.applog.game.GameReportHelper;
import com.sdk.douyou.DouYou;
import com.sdk.douyou.adapter.DouYouSDKListenerAdapter;
import com.sdk.douyou.bean.OrderInfoBean;
import com.sdk.douyou.listen.DouYouSDKListener;
import com.sdk.douyou.listen.DouyouActivityCallback;
import com.sdk.douyou.util.DouYouSDKTools;

public class TouTiaoManagement {
    private String APPID;
    private String APPName;
    private String Channel;
    private static TouTiaoManagement instance;

    public static TouTiaoManagement getInstance() {
        if (instance == null) {
            instance = new TouTiaoManagement();
        }
        return instance;
    }

    public void initSDK(Activity context) {
        this.getParams(context);
        this.init(context);
    }

    private void getParams(Activity context) {
        this.APPID = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_ID");
        this.APPName = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_APP_NAME");
        this.Channel = DouYouSDKTools.getMetaData((Context)context, (String)"DY_TOUTIAO_CHANNEL");
        Log.e((String)"DYTouTiao", (String)("APPID: " + this.APPID));
        Log.e((String)"DYTouTiao", (String)("APPName: " + this.APPName));
        Log.e((String)"DYTouTiao", (String)("Channel: " + this.Channel));
    }

    private void init(final Activity context) {
        Log.e((String)"DYTouTiao", (String)"toutiao  sdk-V6.14.3 init: start ");
        InitConfig config = new InitConfig(this.APPID, this.Channel);
        config.setUriConfig(0);
        config.setLogger(new ILogger(){

            public void log(String msg, Throwable throwable) {
                Log.e((String)"DYTouTiao", (String)("s:" + msg));
            }
        });
        config.setEnablePlay(true);
        config.setAbEnable(true);
        config.setAutoStart(true);
        config.setImeiEnable(false);
        config.setAutoTrackEnabled(true);
        config.setLogEnable(true);
        AppLog.setEncryptAndCompress((boolean)true);
        AppLog.init((Context)context, (InitConfig)config);
        Log.e((String)"DYTouTiao", (String)"toutiao sdk init: end");
        DouYou.getInstance().setSDKListener((DouYouSDKListener)new DouYouSDKListenerAdapter(){

            public void onPayResult(int code, OrderInfoBean params) {
                switch (code) {
                    case 10: {
                        Log.e((String)"DYTouTiao", (String)"pay success");
                        TouTiaoManagement.this.purchase(params, true);
                        Log.e((String)"DYTouTiao", (String)"toutiao pay success");
                    }
                }
            }

            public void onResult(int code, String msg) {
                switch (code) {
                    case 39: {
                        Log.e((String)"DYTouTiao", (String)"register success");
                        TouTiaoManagement.this.setRegister("wechat", true);
                        Log.e((String)"DYTouTiao", (String)"toutiao register success");
                    }
                }
            }
        });
        DouYou.getInstance().setActivityCallback(new DouyouActivityCallback(){

            public void onCreate(Bundle savedInstanceState) {
            }

            public void onStart() {
            }

            public void onPause() {
                Log.e((String)"DYTouTiao", (String)"onPause: ");
                AppLog.onPause((Context)context);
            }

            public void onResume() {
                Log.e((String)"DYTouTiao", (String)"onResume: ");
                AppLog.onResume((Context)context);
            }

            public void onStop() {
            }

            public void onDestroy() {
            }

            public void onRestart() {
            }

            public void onBackPressed() {
            }

            public void onNewIntent(Intent newIntent) {
            }

            public void onConfigurationChanged(Configuration newConfig) {
            }

            public void onSaveInstanceState(Bundle paramBundle) {
            }

            public void onActivityResult(int requestCode, int resultCode, Intent data) {
            }

            public void onRequestPermissionsResult(int requestCode, String[] permissions, int[] grantResults) {
            }

            public void onWindowFocusChanged(boolean paramBoolean) {
            }
        });
    }

    private void setRegister(String method, boolean is_success) {
        GameReportHelper.onEventRegister((String)"wechat", (boolean)is_success);
    }

    private void purchase(OrderInfoBean params, boolean is_success) {
        Log.d((String)"DouYou", (String)("report_money=" + Double.valueOf(params.getTrue_money()).floatValue()));
        AppLog.setOaidObserver((IOaidObserver)new IOaidObserver(){

            public void onOaidLoaded(IOaidObserver.Oaid oaid) {
                Log.e((String)"DYTouTiao", (String)("\u5934\u6761\u81ea\u5df1\u751f\u6210\u7684oaid : " + oaid.id));
            }
        });
        GameReportHelper.onEventPurchase((String)params.getProductName(), (String)params.getProductName(), (String)params.getProductId(), (int)1, null, (String)"\u00a5", (boolean)is_success, (int)Integer.parseInt(params.getTrue_money()));
    }
}

