/*
 * Decompiled with CFR 0.152.
 */
package com.bytedance.applog.log;

import com.bytedance.applog.log.ILogProcessor;
import com.bytedance.applog.log.LogInfo;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;

public class LogProcessorHolder {
    private static final CopyOnWriteArraySet<ILogProcessor> commonProcessors = new CopyOnWriteArraySet();
    private static final Map<String, ILogProcessor> mAppProcessors = new ConcurrentHashMap<String, ILogProcessor>();

    public static void addProcessor(ILogProcessor processor) {
        commonProcessors.add(processor);
    }

    public static void setProcessor(String appId, ILogProcessor processor) {
        mAppProcessors.put(appId, processor);
    }

    public static boolean noAnyProcessor() {
        return commonProcessors.isEmpty() && mAppProcessors.isEmpty();
    }

    public static Iterator<ILogProcessor> getCommonProcessors() {
        return commonProcessors.iterator();
    }

    public static Iterator<ILogProcessor> getAppProcessors() {
        return mAppProcessors.values().iterator();
    }

    public static ILogProcessor getAppProcessor(String appId) {
        if (LogProcessorHolder.isNotEmpty(appId)) {
            return mAppProcessors.get(appId);
        }
        return null;
    }

    public static void commonProcess(LogInfo log) {
        if (null == log) {
            return;
        }
        if (commonProcessors.isEmpty()) {
            return;
        }
        Iterator<ILogProcessor> processorIterator = LogProcessorHolder.getCommonProcessors();
        while (processorIterator.hasNext()) {
            processorIterator.next().onLog(log);
        }
    }

    private static boolean isNotEmpty(String s) {
        return null != s && s.length() > 0;
    }
}

