/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.browser;

import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.view.View;

public class GarbageCollectionHandler
extends Handler {
    private final AttachFilter attachFilter;
    private final RecycleCallback recycleCallback;
    private final long delay;

    private GarbageCollectionHandler() {
        this.attachFilter = null;
        this.recycleCallback = null;
        this.delay = 60000L;
    }

    public GarbageCollectionHandler(Looper looper, AttachFilter attachFilter, RecycleCallback recycleCallback, long delay) {
        super(looper);
        this.attachFilter = attachFilter;
        this.recycleCallback = recycleCallback;
        this.delay = delay;
    }

    public void handleMessage(Message msg) {
        super.handleMessage(msg);
        if (this.attachFilter == null) {
            return;
        }
        if (this.recycleCallback == null) {
            return;
        }
        if (!(msg.obj instanceof View)) {
            return;
        }
        View view = (View)msg.obj;
        if (!this.attachFilter.attached(view)) {
            this.recycleCallback.onRecycle(view);
        } else if (this.delay > 0L) {
            this.sendMessageDelayed(Message.obtain((Message)msg), this.delay);
        }
    }

    public static interface RecycleCallback {
        public void onRecycle(View var1);
    }

    public static interface AttachFilter {
        public boolean attached(View var1);
    }
}

