/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.dialog;

import android.app.Activity;
import android.app.Dialog;
import android.content.Context;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.tds.common.R;
import com.tds.common.utils.UIUtils;
import com.tds.common.widgets.HoloThemeHelper;
import com.tds.common.widgets.dialog.SafeDialogFragment;

public abstract class AbstractAlertDialog
extends SafeDialogFragment {
    protected Activity mActivity;

    public abstract View getContentView();

    public abstract Event leftEvent();

    public abstract Event rightEvent();

    public abstract int[] getLayoutParams();

    public void onAttach(Context context) {
        super.onAttach(context);
        this.mActivity = (Activity)context;
    }

    public void onStart() {
        super.onStart();
        Activity activity = this.getActivity();
        Dialog dialog = this.getDialog();
        if (dialog == null || activity == null || activity.getWindowManager() == null || dialog.getWindow() == null) {
            return;
        }
        dialog.getWindow().setLayout(this.getLayoutParams()[0], -2);
        dialog.getWindow().setBackgroundDrawable((Drawable)new ColorDrawable(0));
        dialog.setCancelable(false);
        dialog.setCanceledOnTouchOutside(false);
        HoloThemeHelper.fixHoloDialogBlueLine(dialog);
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.tds_common_view_alert, container, false);
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        if (this.getArguments() == null) {
            this.dismiss();
            return;
        }
        this.initView(view);
    }

    private void initView(View view) {
        TextView mTvNegative = (TextView)view.findViewById(R.id.tv_alert_negative);
        TextView mTvPositive = (TextView)view.findViewById(R.id.tv_alert_positive);
        if (this.leftEvent() != null) {
            mTvNegative.setText((CharSequence)this.leftEvent().text);
            mTvNegative.setOnClickListener(this.leftEvent().listener);
            mTvNegative.setVisibility(0);
        } else {
            mTvNegative.setVisibility(8);
        }
        if (this.rightEvent() != null) {
            mTvPositive.setText((CharSequence)this.rightEvent().text);
            mTvPositive.setOnClickListener(this.rightEvent().listener);
            mTvPositive.setVisibility(0);
        } else {
            mTvPositive.setVisibility(8);
        }
        if (view instanceof LinearLayout && this.getContentView() != null) {
            ViewGroup.LayoutParams viewLayoutParams = new ViewGroup.LayoutParams(-1, UIUtils.dp2px((Context)this.getActivity(), 75.0f));
            ((LinearLayout)view).addView(this.getContentView(), 0, viewLayoutParams);
        }
    }

    public static class Event {
        String text;
        View.OnClickListener listener;

        public Event(String text, View.OnClickListener listener) {
            this.text = text;
            this.listener = listener;
        }
    }

    public static interface AlertClickCallback {
        public void onLeftClick();

        public void onRightClick();
    }
}

