/*
 * Decompiled with CFR 0.152.
 */
package com.tds.common.widgets.image;

import android.annotation.SuppressLint;
import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.tds.common.net.TdsHttp;
import com.tds.common.reactor.Subscription;
import com.tds.common.widgets.image.DiskCache;
import com.tds.common.widgets.image.LoadBuilder;
import com.tds.common.widgets.image.MemCache;
import java.io.File;
import java.util.Map;
import java.util.WeakHashMap;

public final class TdsImage {
    @SuppressLint(value={"StaticFieldLeak"})
    private static TdsImage instance;
    final Context context;
    final TdsHttp.Client client;
    final MemCache memCache;
    final DiskCache diskCache;
    final Map<Object, Subscription> targetToAction;

    private TdsImage(Context context) {
        if (context == null) {
            throw new IllegalArgumentException("context cannot be null");
        }
        this.context = context;
        this.client = TdsHttp.newClientBuilder().build();
        this.memCache = new MemCache(context);
        this.diskCache = new DiskCache(context);
        this.targetToAction = new WeakHashMap<Object, Subscription>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TdsImage get(Context context) {
        if (instance != null) return instance;
        Class<TdsImage> clazz = TdsImage.class;
        synchronized (TdsImage.class) {
            if (instance != null) return instance;
            instance = new TdsImage(context.getApplicationContext());
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return instance;
        }
    }

    public LoadBuilder load(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return this.load((Uri)null);
        }
        return this.load(Uri.parse((String)url));
    }

    public LoadBuilder load(File file) {
        if (file == null) {
            return this.load((Uri)null);
        }
        return this.load(Uri.fromFile((File)file));
    }

    public LoadBuilder load(int resId) {
        return new LoadBuilder(this, null, resId);
    }

    LoadBuilder load(Uri uri) {
        return new LoadBuilder(this, uri, 0);
    }

    void enqueue(Object target, Subscription subscription) {
        Subscription old = this.targetToAction.get(target);
        if (old != subscription) {
            this.cancelRequest(target);
            this.targetToAction.put(target, subscription);
        }
    }

    public void cancelRequest(Object target) {
        Subscription subscription;
        if (target != null && (subscription = this.targetToAction.remove(target)) != null) {
            subscription.unsubscribe();
        }
    }
}

