/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.models;

import android.content.Context;
import com.tapsdk.antiaddiction.entities.CheckPlayResult;
import com.tapsdk.antiaddiction.entities.UserInfo;
import com.tapsdk.antiaddiction.entities.request.PlayLogRequestParams;
import com.tapsdk.antiaddiction.rest.api.AntiAddictionApi;
import com.tapsdk.antiaddiction.settings.AntiAddictionSettings;
import com.tapsdk.antiaddiction.skynet.Skynet;
import com.tapsdk.antiaddiction.skynet.exceptions.AntiServerException;
import com.tapsdk.antiaddiction.skynet.okhttp3.internal.http.RealResponseBody;
import com.tapsdk.antiaddiction.skynet.retrofit2.Response;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.TimeUtil;
import java.util.Arrays;

public class PlayLogModel {
    public static PlayLogRequestParams getPlayLog(Context context, UserInfo userInfo, String game, long serverStartTime, long serverEndTime, long localStartTime, long localEndTime, long serverTime) {
        int timesLength;
        long[][] sendTimes;
        long[][] savedTimes = PlayLogModel.getUnSentGameTimes(context, userInfo);
        if (PlayLogModel.checkSavedTimeStamp(savedTimes, serverTime)) {
            sendTimes = new long[savedTimes.length + 1][];
            timesLength = savedTimes.length + 1;
            System.arraycopy(savedTimes, 0, sendTimes, 0, savedTimes.length);
        } else {
            AntiAddictionSettings.getInstance().clearHistoricalData(context, userInfo.userId);
            timesLength = 1;
            sendTimes = new long[1][];
        }
        sendTimes[timesLength - 1] = new long[]{serverStartTime, serverEndTime, localStartTime, localEndTime};
        PlayLogRequestParams result = new PlayLogRequestParams();
        result.game = game;
        for (long[] time : sendTimes) {
            result.playLogs.serverTimes.add(Arrays.asList(time[0], time[1]));
            result.playLogs.localTimes.add(Arrays.asList(time[2], time[3]));
        }
        return result;
    }

    public static long[][] getUnSentGameTimes(Context context, UserInfo userInfo) {
        if (userInfo == null) {
            return new long[1][];
        }
        String savedTimes = AntiAddictionSettings.getInstance().getHistoricalData(context, userInfo.userId);
        AntiAddictionLogger.d("savedTimes:" + savedTimes);
        if (savedTimes.length() == 0) {
            return null;
        }
        String[] segments = savedTimes.split(";");
        if (segments.length == 0) {
            return null;
        }
        long[][] timeArray = new long[segments.length][];
        for (int i = 0; i < segments.length; ++i) {
            String[] times = segments[i].split(",");
            timeArray[i] = new long[4];
            for (int j = 0; j < times.length; ++j) {
                timeArray[i][j] = Long.parseLong(times[j]);
            }
        }
        return timeArray;
    }

    private static boolean checkSavedTimeStamp(long[][] saved, long serverTimeInSeconds) {
        if (null != saved && saved.length > 0 && saved[0] != null) {
            if (saved.length > 2000) {
                return false;
            }
            long intervalInMillis = saved[0][0];
            return TimeUtil.isSameDayOfMillis(intervalInMillis * 1000L, serverTimeInSeconds * 1000L);
        }
        return false;
    }

    public static Response<CheckPlayResult> checkUserStateSync(PlayLogRequestParams playLogRequestParams, boolean upload, String clientId, String userId) {
        return PlayLogModel.uploadPlayLogSync(playLogRequestParams, true, upload, clientId, userId);
    }

    public static Response<CheckPlayResult> uploadPlayLogSync(PlayLogRequestParams playLogs, boolean isLogin, boolean upload, String clientId, String userId) {
        if (!upload) {
            return Response.error(400, new RealResponseBody("", 0L, null));
        }
        try {
            AntiAddictionApi api = Skynet.getService(Skynet.RETROFIT_FOR_ANTI_ADDICTION, AntiAddictionApi.class);
            playLogs.login = isLogin ? 1 : 0;
            return api.checkPlay(clientId, userId).execute();
        }
        catch (Exception e) {
            AntiAddictionLogger.printStackTrace(e);
            if (e instanceof AntiServerException) {
                AntiServerException antiServerException = (AntiServerException)e;
                return Response.error(antiServerException.statusCode, new RealResponseBody("", 0L, null));
            }
            return Response.error(400, new RealResponseBody("", 0L, null));
        }
    }
}

