/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.reactor.internal.operators;

import com.tapsdk.antiaddiction.reactor.Observable;
import com.tapsdk.antiaddiction.reactor.Subscriber;
import com.tapsdk.antiaddiction.reactor.exceptions.Exceptions;
import com.tapsdk.antiaddiction.reactor.plugins.RxJavaHooks;

public final class OnSubscribeLift<T, R>
implements Observable.OnSubscribe<R> {
    final Observable.OnSubscribe<T> parent;
    final Observable.Operator<? extends R, ? super T> operator;

    public OnSubscribeLift(Observable.OnSubscribe<T> parent, Observable.Operator<? extends R, ? super T> operator) {
        this.parent = parent;
        this.operator = operator;
    }

    @Override
    public void call(Subscriber<? super R> o) {
        try {
            Subscriber st = (Subscriber)RxJavaHooks.onObservableLift(this.operator).call(o);
            try {
                st.onStart();
                this.parent.call(st);
            }
            catch (Throwable e) {
                Exceptions.throwIfFatal(e);
                st.onError(e);
            }
        }
        catch (Throwable e) {
            Exceptions.throwIfFatal(e);
            o.onError(e);
        }
    }
}

