/*
 * Decompiled with CFR 0.152.
 */
package com.tapsdk.antiaddiction.settings;

import android.content.Context;
import android.content.SharedPreferences;
import android.text.TextUtils;
import com.tapsdk.antiaddiction.entities.CommonConfig;
import com.tapsdk.antiaddiction.entities.FourTuple;
import com.tapsdk.antiaddiction.entities.HealthPromptGroup;
import com.tapsdk.antiaddiction.entities.Prompt;
import com.tapsdk.antiaddiction.entities.TwoTuple;
import com.tapsdk.antiaddiction.enums.AccountLimitTipEnum;
import com.tapsdk.antiaddiction.skynet.okio.ByteString;
import com.tapsdk.antiaddiction.utils.AntiAddictionLogger;
import com.tapsdk.antiaddiction.utils.FileUtil;
import com.tapsdk.antiaddiction.utils.UIConfigHelper;
import com.tapsdk.antiaddiction.utils.Utils;
import com.tds.gson.Gson;
import com.tds.gson.GsonBuilder;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class AntiAddictionSettings {
    private final Map<String, SharedPreferences> spCache = new HashMap<String, SharedPreferences>();
    private CommonConfig commonConfig = null;
    private final Map<Integer, Map<Integer, TwoTuple<String, String>>> promptDict = new HashMap<Integer, Map<Integer, TwoTuple<String, String>>>();
    private final Map<Integer, FourTuple<String, String, String, String>> authIdentifierPromptDict = new HashMap<Integer, FourTuple<String, String, String, String>>();
    private Set<String> holidaySet = new HashSet<String>();
    private final Gson gson = new GsonBuilder().create();

    private AntiAddictionSettings() {
    }

    public static AntiAddictionSettings getInstance() {
        return Holder.INSTANCE;
    }

    private String getSPNameByToken(String userId) {
        StringBuilder sb = new StringBuilder();
        if (!TextUtils.isEmpty((CharSequence)userId)) {
            sb.append(ByteString.encodeString(userId, StandardCharsets.UTF_8).md5()).append("_");
        }
        return sb.append("timing_file_suffix").toString();
    }

    public SharedPreferences getSpecificSharedPreference(Context context, String spName) {
        if (this.spCache.get(spName) != null) {
            return this.spCache.get(spName);
        }
        SharedPreferences sp = context.getSharedPreferences(spName, 0);
        this.spCache.put(spName, sp);
        return sp;
    }

    public void cacheAuthInputInfo(Context context, String userId, String authInputInfo) {
        SharedPreferences.Editor editor = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).edit();
        editor.putString("auth_input_info", authInputInfo);
        editor.apply();
    }

    public void clearAuthInputInfo(Context context, String userId) {
        SharedPreferences.Editor editor = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).edit();
        editor.putString("auth_input_info", "");
        editor.apply();
    }

    public String getAuthInputInfo(Context context, String userId) {
        SharedPreferences sp = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId));
        return sp.getString("auth_input_info", "");
    }

    public void cacheUserInfo(Context context, String userId, String accessToken, int ageLimit) {
        if (accessToken == null || accessToken.isEmpty()) {
            return;
        }
        SharedPreferences.Editor editor = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).edit();
        editor.putString("access_token", accessToken);
        editor.putInt("age_limit", ageLimit);
        editor.apply();
    }

    public TwoTuple<String, Integer> getCachedUserInfo(Context context, String userId) {
        SharedPreferences sharedPreferences = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId));
        String accessToken = sharedPreferences.getString("access_token", "");
        Integer ageLimit = sharedPreferences.getInt("age_limit", -1);
        return TwoTuple.create(accessToken, ageLimit);
    }

    public String getHistoricalData(Context context, String userId) {
        return this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).getString("timing_shared_preference_name", "");
    }

    public void saveLatestData(Context context, String userId, long start, long end, long localStart, long localEnd) {
        SharedPreferences.Editor editor = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).edit();
        String historicalData = AntiAddictionSettings.getInstance().getHistoricalData(context, userId);
        String latestData = historicalData + start + "," + end + "," + localStart + "," + localEnd + ";";
        editor.putString("timing_shared_preference_name", latestData);
        editor.apply();
    }

    public void clearHistoricalData(Context context, String userId) {
        AntiAddictionLogger.d("clearHistorical play Date");
        SharedPreferences.Editor editor = this.getSpecificSharedPreference(context, this.getSPNameByToken(userId)).edit();
        editor.putString("timing_shared_preference_name", "");
        editor.apply();
    }

    private void initTipDict(List<HealthPromptGroup> healthReminderWordsList) {
        this.promptDict.clear();
        for (int i = 0; i < healthReminderWordsList.size(); ++i) {
            HealthPromptGroup promptGroup = healthReminderWordsList.get(i);
            int accountType = promptGroup.accountType;
            HashMap<Integer, TwoTuple<String, String>> promptInfoMap = new HashMap<Integer, TwoTuple<String, String>>();
            List<Prompt> promptList = promptGroup.promptList;
            for (int j = 0; j < promptList.size(); ++j) {
                Prompt prompt = promptList.get(j);
                promptInfoMap.put(prompt.type, TwoTuple.create(prompt.title, prompt.description));
            }
            this.promptDict.put(accountType, promptInfoMap);
        }
    }

    private void initAuthIdentifyPromptDict(List<Prompt> authIdentifyPromptList) {
        this.authIdentifierPromptDict.clear();
        for (Prompt prompt : authIdentifyPromptList) {
            this.authIdentifierPromptDict.put(prompt.type, FourTuple.create(prompt.title, prompt.description, prompt.negativeButton, prompt.positiveButton));
        }
        Utils.printMap(this.authIdentifierPromptDict);
    }

    public void setCommonConfig(CommonConfig commonConfig) {
        if (commonConfig == null || commonConfig.uiConfig == null) {
            String illegalArgumentName = commonConfig == null ? "CommonConfig" : "UIConfig";
            AntiAddictionLogger.w("illegal arguments:" + illegalArgumentName);
            return;
        }
        this.initTipDict(commonConfig.uiConfig.healthPromptGroups);
        this.initAuthIdentifyPromptDict(commonConfig.uiConfig.authIdentifyPromptList);
        this.initHolidaySet(commonConfig.holidayList);
        UIConfigHelper.INSTANCE.init(commonConfig);
        this.commonConfig = commonConfig;
    }

    public CommonConfig getCommonConfig() {
        return this.commonConfig;
    }

    public CommonConfig getCommonDefaultConfig(Context context) {
        CommonConfig defaultConfig = null;
        try {
            defaultConfig = (CommonConfig)new GsonBuilder().create().fromJson(FileUtil.getJsonFromAssetsFile(context, "default_config.json"), CommonConfig.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaultConfig;
    }

    public TwoTuple<String, String> getPromptInfo(int ageLimit, int type) {
        Map<Integer, TwoTuple<String, String>> promptInfoMap;
        int accountType = ageLimit >= 0 ? 1 : 0;
        TwoTuple<String, String> promptInfo = null;
        if (this.promptDict.containsKey(accountType) && (promptInfoMap = this.promptDict.get(accountType)) != null) {
            promptInfo = promptInfoMap.get(type);
        }
        if (promptInfo != null) {
            return promptInfo;
        }
        return TwoTuple.create("", "");
    }

    public void initHolidaySet(List<String> holidays) {
        if (holidays != null && holidays.size() > 0) {
            this.holidaySet = new HashSet<String>(holidays);
        }
    }

    public boolean isHolidayInMillis(long timeMillis) {
        SimpleDateFormat formatter = new SimpleDateFormat("MM.dd", Locale.getDefault());
        return this.isHoliday(formatter.format(timeMillis));
    }

    public boolean isHoliday(String date) {
        return this.holidaySet.contains(date);
    }

    public boolean uploadUserAction() {
        if (this.commonConfig != null) {
            return this.commonConfig.uploadUserAction == 1;
        }
        return true;
    }

    public Map<String, Object> generateAlertMessage(String content, String description, AccountLimitTipEnum limitTipEnum, int strictType) {
        AntiAddictionLogger.d("-------generateAlertMessage-------");
        HashMap<String, Object> result = new HashMap<String, Object>();
        result.put("title", content);
        result.put("description", description);
        result.put("limit_tip_type", (Object)limitTipEnum);
        result.put("strict_type", strictType);
        AntiAddictionLogger.d("generateAlertMessage:" + this.gson.toJson(result));
        return result;
    }

    static class Holder {
        static AntiAddictionSettings INSTANCE = new AntiAddictionSettings();

        Holder() {
        }
    }
}

