/*
 * Decompiled with CFR 0.152.
 */
package cn.sharesdk.unity3d;

import android.app.Activity;
import android.content.Context;
import android.text.TextUtils;
import cn.sharesdk.framework.Platform;
import cn.sharesdk.framework.PlatformActionListener;
import cn.sharesdk.framework.ShareSDK;
import cn.sharesdk.framework.ShareSDKCallback;
import cn.sharesdk.framework.loopshare.LoopShareResultListener;
import cn.sharesdk.onekeyshare.OnekeyShare;
import cn.sharesdk.onekeyshare.ShareContentCustomizeCallback;
import cn.sharesdk.unity3d.ShareSDKLog;
import cn.sharesdk.unity3d.ShareSDKThreadPool;
import cn.sharesdk.unity3d.Unity3dPlatformActionListener;
import cn.sharesdk.unity3d.Unity3dPlatformLoopShareResultListener;
import com.mob.MobSDK;
import com.mob.commons.MobProduct;
import com.mob.commons.SHARESDK;
import com.mob.tools.utils.Hashon;
import com.unity3d.player.UnityPlayer;
import java.util.HashMap;
import java.util.Map;

public class ShareSDKUtils {
    private static boolean disableSSO = false;
    private static Context context;
    private static String u3dGameObject;
    private static String u3dCallback;

    public ShareSDKUtils(String gameObject, String callback) {
        ShareSDKLog.d("ShareSDKUtils.prepare");
        if (context == null) {
            context = UnityPlayer.currentActivity.getApplicationContext();
        }
        if (!TextUtils.isEmpty((CharSequence)gameObject)) {
            u3dGameObject = gameObject;
        }
        if (!TextUtils.isEmpty((CharSequence)callback)) {
            u3dCallback = callback;
        }
    }

    public void initSDK(String appKey, String screct) {
        ShareSDKLog.d("initSDK appkey ==>>" + appKey + "appscrect ==>>" + screct);
        if (!TextUtils.isEmpty((CharSequence)appKey) && !TextUtils.isEmpty((CharSequence)screct)) {
            MobSDK.init((Context)context, (String)appKey, (String)screct);
        } else if (!TextUtils.isEmpty((CharSequence)appKey)) {
            MobSDK.init((Context)context, (String)appKey);
        } else {
            MobSDK.init((Context)context);
        }
    }

    public void prepareLoopShare() {
        if (!MobSDK.isForb()) {
            ShareSDK.prepareLoopShare((LoopShareResultListener)new Unity3dPlatformLoopShareResultListener(u3dGameObject, u3dCallback));
            ShareSDKLog.i("ShareSDKUtils prepareLoopShare set is ok");
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void setChannelId() {
        try {
            MobSDK.setChannel((MobProduct)new SHARESDK(), (int)2);
            ShareSDKLog.i("ShareSDKUtils setChannelId set is ok");
        }
        catch (Throwable t) {
            ShareSDKLog.e("ShareSDKUtils setChannelId error: ", t);
        }
    }

    public void setPlatformConfig(final String configs) {
        ShareSDKLog.d("initSDK configs ==>>" + configs);
        if (!MobSDK.isForb()) {
            if (!TextUtils.isEmpty((CharSequence)configs)) {
                ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                    @Override
                    public void safeRun() {
                        HashMap devInfo = new Hashon().fromJson(configs);
                        ShareSDK.getPlatformList();
                        for (Map.Entry entry : devInfo.entrySet()) {
                            String p = ShareSDK.platformIdToName((int)Integer.parseInt((String)entry.getKey()));
                            if (p == null) continue;
                            ShareSDKLog.d(String.valueOf(p) + " ==>>" + new Hashon().fromHashMap((HashMap)entry.getValue()));
                            ShareSDK.setPlatformDevInfo((String)p, (HashMap)((HashMap)entry.getValue()));
                        }
                    }
                }, 1000L);
            }
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void authorize(final int reqID, final int platform) {
        ShareSDKLog.d("ShareSDKUtils.authorize");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener.setReqID(reqID);
                    Platform plat = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
                    if (plat == null) {
                        ShareSDKLog.d("plat is null");
                        return;
                    }
                    plat.setPlatformActionListener((PlatformActionListener)paListener);
                    plat.SSOSetting(disableSSO);
                    plat.authorize();
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void removeAccount(final int platform) {
        ShareSDKLog.d("ShareSDKUtils.removeAccount");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform)).removeAccount(true);
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public boolean isAuthValid(int platform) {
        ShareSDKLog.d("ShareSDKUtils.isAuthValid");
        if (!MobSDK.isForb()) {
            return ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform)).isAuthValid();
        }
        ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        return false;
    }

    public boolean isClientValid(int platform) {
        ShareSDKLog.d("ShareSDKUtils.isClientValid");
        if (!MobSDK.isForb()) {
            return ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform)).isClientValid();
        }
        ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        return false;
    }

    public void showUser(final int reqID, final int platform) {
        ShareSDKLog.d("ShareSDKUtils.showUser");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Unity3dPlatformActionListener paListener2 = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener2.setReqID(reqID);
                    Platform plat2 = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
                    if (plat2 == null) {
                        ShareSDKLog.d("plat is null");
                        return;
                    }
                    plat2.setPlatformActionListener((PlatformActionListener)paListener2);
                    plat2.SSOSetting(disableSSO);
                    plat2.showUser((String)null);
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void shareContent(final int reqID, final int platform, final String content) {
        ShareSDKLog.d("ShareSDKUtils.share");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Unity3dPlatformActionListener paListener3 = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener3.setReqID(reqID);
                    Platform platform2 = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
                    if (platform2 == null) {
                        ShareSDKLog.d("plat is null");
                        return;
                    }
                    platform2.setPlatformActionListener((PlatformActionListener)paListener3);
                    platform2.SSOSetting(disableSSO);
                    try {
                        String pID;
                        HashMap customizeSP;
                        Hashon hashon = new Hashon();
                        ShareSDKLog.d("share content ==>>" + content);
                        HashMap data = hashon.fromJson(content);
                        Platform.ShareParams sp = new Platform.ShareParams(data);
                        Activity activity = UnityPlayer.currentActivity;
                        if (activity != null) {
                            sp.setActivity(activity);
                            ShareSDK.setActivity((Activity)activity);
                            ShareSDKLog.d("doShare setActivity");
                        }
                        if (data.containsKey("customizeShareParams") && (customizeSP = (HashMap)data.get("customizeShareParams")).size() > 0 && customizeSP.containsKey(pID = String.valueOf(platform))) {
                            String cSP = (String)customizeSP.get(pID);
                            ShareSDKLog.d("share content ==>>" + cSP);
                            HashMap data2 = hashon.fromJson(cSP);
                            for (String key : data2.keySet()) {
                                sp.set(key, data2.get(key));
                            }
                        }
                        platform2.share(sp);
                    }
                    catch (Throwable t) {
                        paListener3.onError(platform2, 9, t);
                    }
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void onekeyShare(final int reqID, final int platform, final String content) {
        ShareSDKLog.d("ShareSDKUtils.OnekeyShare");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Activity activity2;
                    HashMap customizeSP2;
                    Unity3dPlatformActionListener paListener4 = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener4.setReqID(reqID);
                    final Hashon hashon = new Hashon();
                    ShareSDKLog.d("onekeyshare  ==>>" + content);
                    HashMap map = hashon.fromJson(content);
                    OnekeyShare oks = new OnekeyShare();
                    if (platform > 0) {
                        String str = ShareSDK.platformIdToName((int)platform);
                        ShareSDKLog.d("ShareSDKUtils Onekeyshare shareView platform name ==>> " + str);
                        if (!TextUtils.isEmpty((CharSequence)str)) {
                            oks.setPlatform(str);
                            oks.setSilent(false);
                        }
                    }
                    if (map.containsKey("hidePlatformList")) {
                        String hidePlatformList = (String)map.get("hidePlatformList");
                        String[] stringList = hidePlatformList.split(",");
                        if (!TextUtils.isEmpty((CharSequence)hidePlatformList) && stringList != null && stringList.length > 0) {
                            for (String str2 : stringList) {
                                oks.addHiddenPlatform(ShareSDK.platformIdToName((int)Integer.parseInt(str2)));
                            }
                        }
                    }
                    if (map.containsKey("text")) {
                        oks.setText((String)map.get("text"));
                    }
                    if (map.containsKey("imagePath")) {
                        oks.setImagePath((String)map.get("imagePath"));
                    }
                    if (map.containsKey("imageUrl")) {
                        oks.setImageUrl((String)map.get("imageUrl"));
                    }
                    if (map.containsKey("imageArray")) {
                        oks.setImageArray(((String)map.get("imageArray")).split(","));
                    }
                    if (map.containsKey("title")) {
                        oks.setTitle((String)map.get("title"));
                    }
                    if (map.containsKey("comment")) {
                        oks.setComment((String)map.get("comment"));
                    }
                    if (map.containsKey("url")) {
                        oks.setUrl((String)map.get("url"));
                    }
                    if (map.containsKey("titleUrl")) {
                        oks.setTitleUrl((String)map.get("titleUrl"));
                    }
                    if (map.containsKey("site")) {
                        oks.setSite((String)map.get("site"));
                    }
                    if (map.containsKey("siteUrl")) {
                        oks.setSiteUrl((String)map.get("siteUrl"));
                    }
                    if (map.containsKey("musicUrl")) {
                        oks.setMusicUrl((String)map.get("musicUrl"));
                    }
                    if (map.containsKey("filePath")) {
                        oks.setFilePath((String)map.get("filePath"));
                    }
                    if (map.containsKey("shareType") && "6".equals(String.valueOf(map.get("shareType"))) && map.containsKey("url")) {
                        oks.setVideoUrl((String)map.get("url"));
                    }
                    if (map.containsKey("customizeShareParams") && (customizeSP2 = (HashMap)map.get("customizeShareParams")).size() > 0) {
                        oks.setShareContentCustomizeCallback(new ShareContentCustomizeCallback(){

                            public void onShare(Platform platform3, Platform.ShareParams paramsToShare) {
                                String platformID2 = String.valueOf(ShareSDK.platformNameToId((String)platform3.getName()));
                                if (customizeSP2.containsKey(platformID2)) {
                                    String content3 = (String)customizeSP2.get(platformID2);
                                    ShareSDKLog.d("share content ==>>" + content3);
                                    HashMap data3 = hashon.fromJson(content3);
                                    for (String key2 : data3.keySet()) {
                                        paramsToShare.set(key2, data3.get(key2));
                                    }
                                }
                            }
                        });
                    }
                    if ((activity2 = UnityPlayer.currentActivity) != null) {
                        oks.setActivity(activity2);
                        ShareSDK.setActivity((Activity)activity2);
                        ShareSDKLog.d(" oneKeyShare setActivity ");
                    }
                    if (disableSSO) {
                        oks.disableSSOWhenAuthorize();
                    }
                    oks.setCallback((PlatformActionListener)paListener4);
                    oks.show(context);
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void getFriendList(final int reqID, final int platform, final int count, final int page) {
        ShareSDKLog.d("ShareSDKUtils.getFriendList");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Unity3dPlatformActionListener paListener5 = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener5.setReqID(reqID);
                    Platform plat = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
                    if (plat == null) {
                        ShareSDKLog.d("plat is null");
                        return;
                    }
                    plat.setPlatformActionListener((PlatformActionListener)paListener5);
                    plat.SSOSetting(disableSSO);
                    plat.listFriend(count, page, (String)null);
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void followFriend(final int reqID, final int platform, final String account) {
        ShareSDKLog.d("ShareSDKUtils.followFriend");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    Unity3dPlatformActionListener paListener6 = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener6.setReqID(reqID);
                    Platform platform1 = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
                    if (platform1 == null) {
                        ShareSDKLog.d("plat is null");
                        return;
                    }
                    platform1.setPlatformActionListener((PlatformActionListener)paListener6);
                    platform1.SSOSetting(disableSSO);
                    platform1.followFriend(account);
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public String getAuthInfo(int platform) {
        ShareSDKLog.d("ShareSDKUtils.getAuthInfo");
        if (!MobSDK.isForb()) {
            Platform plat = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platform));
            if (plat == null) {
                return "error:platform is invaild";
            }
            Hashon hashon = new Hashon();
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (plat.isAuthValid()) {
                map.put("expiresIn", plat.getDb().getExpiresIn());
                map.put("expiresTime", plat.getDb().getExpiresTime());
                map.put("token", plat.getDb().getToken());
                map.put("refresh_token", plat.getDb().get("refresh_token"));
                map.put("tokenSecret", plat.getDb().getTokenSecret());
                map.put("userGender", plat.getDb().getUserGender());
                map.put("userID", plat.getDb().getUserId());
                map.put("openID", plat.getDb().get("openid"));
                map.put("unionID", plat.getDb().get("unionid"));
                map.put("userName", plat.getDb().getUserName());
                map.put("userIcon", plat.getDb().getUserIcon());
            }
            return hashon.fromHashMap(map);
        }
        ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        return "";
    }

    public void isClientValidForAndroid(final int reqID, final int platName) {
        ShareSDKLog.d("ShareSDKUtils.isClientValidForAndroid");
        if (!MobSDK.isForb()) {
            ShareSDKThreadPool.singleExecute(new ShareSDKThreadPool.SafeRunnable(){

                @Override
                public void safeRun() {
                    final Unity3dPlatformActionListener paListener = new Unity3dPlatformActionListener(u3dGameObject, u3dCallback);
                    paListener.setReqID(reqID);
                    final Platform platform = ShareSDK.getPlatform((String)ShareSDK.platformIdToName((int)platName));
                    try {
                        boolean clientValid = platform.isClientValid();
                        HashMap<String, Object> map = new HashMap<String, Object>();
                        map.put("state", clientValid ? "install" : "uninstall");
                        paListener.onComplete(platform, 12, map);
                    }
                    catch (Throwable t) {
                        ShareSDKLog.d("ShareSDKUtils.isClientValidForAndroid" + t.getMessage());
                        platform.isClientValid((ShareSDKCallback)new ShareSDKCallback<Boolean>(){

                            public void onCallback(Boolean aBoolean) {
                                HashMap<String, Object> map = new HashMap<String, Object>();
                                map.put("state", aBoolean != false ? "install" : "uninstall");
                                paListener.onComplete(platform, 12, map);
                            }
                        });
                    }
                }
            });
        } else {
            ShareSDKLog.i("check MobSDK submitPolicyGrantResult");
        }
    }

    public void disableSSOWhenAuthorize(boolean open) {
        disableSSO = open;
    }

    public void setDEBUG(boolean debug) {
        ShareSDKLog.isDebug = debug;
    }
}

