/*
 * Decompiled with CFR 0.152.
 */
package com.tencent.bugly.agent;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Looper;
import android.os.Process;
import android.text.TextUtils;
import android.util.Log;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Locale;

public class GameAgent {
    private static final String VERSION = "3.2";
    private static final String LOG_TAG = "CrashReport-GameAgent";
    public static final int GAME_TYPE_UNKNOWN = 0;
    public static final int GAME_TYPE_COCOS = 1;
    public static final int GAME_TYPE_UNITY = 2;
    private static final int LOG_LEVEL_VERBOSE = 0;
    private static final int LOG_LEVEL_DEBUG = 1;
    private static final int LOG_LEVEL_INFO = 2;
    private static final int LOG_LEVEL_WARN = 3;
    private static final int LOG_LEVEL_ERROR = 4;
    private static final int TYPE_U3D_CRASH = 4;
    private static final int TYPE_COCOS2DX_JS_CRASH = 5;
    private static final int TYPE_COCOS2DX_LUA_CRASH = 6;
    private static final String STRATEGY_CLASS_SUFFIX = "BuglyStrategy";
    private static final String OLD_STRATEGY_CLASS_SUFFIX = "crashreport.CrashReport$UserStrategy";
    private static final String CRASH_REPORT_CLASS_SUFFIX = "crashreport.CrashReport";
    private static final String CLASS_UNITY_PLAYER = "com.unity3d.player.UnityPlayer";
    private static final String CLASS_COCOS_ACTIVITY = "org.cocos2dx.lib.Cocos2dxActivity";
    private static String sdkPackageName = "com.tencent.bugly";
    private static Handler sHandler = null;
    private static String sAppVersion = null;
    private static String sAppChannel = null;
    private static String sUserId = null;
    private static boolean sIsDebug = false;
    private static int sGameType = 0;
    private static WeakReference<Activity> sActivity = null;
    private static WeakReference<Context> sContext = null;
    private static boolean hasGuessed = false;

    public static String getVersion() {
        return VERSION;
    }

    public static void printLog(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        if (string.startsWith("<Log>")) {
            GameAgent.printLog(2, string);
        } else if (string.startsWith("<LogDebug>")) {
            GameAgent.printLog(1, string);
        } else if (string.startsWith("<LogInfo>")) {
            GameAgent.printLog(2, string);
        } else if (string.startsWith("<LogWarning>")) {
            GameAgent.printLog(3, string);
        } else if (string.startsWith("<LogAssert>")) {
            GameAgent.printLog(3, string);
        } else if (string.startsWith("<LogError>")) {
            GameAgent.printLog(4, string);
        } else if (string.startsWith("<LogException>")) {
            GameAgent.printLog(4, string);
        } else {
            GameAgent.printLog(0, string);
        }
    }

    private static void printLog(int n, String string) {
        GameAgent.setLog(n, LOG_TAG, string);
    }

    public static Activity getUnityActivity() {
        try {
            Object object = Reflection.getStaticField(CLASS_UNITY_PLAYER, "currentActivity", null);
            if (object != null && object instanceof Activity) {
                return (Activity)object;
            }
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Failed to get activity of Unity.");
        }
        return null;
    }

    public static Activity getCocosActivity() {
        try {
            Object object = Reflection.invokeStaticMethod(CLASS_COCOS_ACTIVITY, "getContext", null, new Class[0]);
            if (object != null && object instanceof Activity) {
                return (Activity)object;
            }
        }
        catch (Exception exception) {
            Log.w((String)LOG_TAG, (String)"Failed to get activity of Cocos.");
        }
        return null;
    }

    private static Activity guessActivity() {
        if (hasGuessed) {
            return null;
        }
        hasGuessed = true;
        Activity activity = null;
        if (sGameType != 0) {
            activity = GameAgent.getActivity();
        }
        if (activity == null) {
            sGameType = 1;
            activity = GameAgent.getActivity();
        }
        if (activity == null) {
            sGameType = 2;
            activity = GameAgent.getActivity();
        }
        if (activity == null) {
            sGameType = 0;
        }
        return activity;
    }

    private static Activity getActivity() {
        if (sActivity == null || sActivity.get() == null) {
            Activity activity;
            switch (sGameType) {
                case 1: {
                    activity = GameAgent.getCocosActivity();
                    break;
                }
                case 2: {
                    activity = GameAgent.getUnityActivity();
                    break;
                }
                default: {
                    Log.w((String)LOG_TAG, (String)"Game type has not been set.");
                    activity = GameAgent.guessActivity();
                }
            }
            if (activity != null) {
                sActivity = new WeakReference<Activity>(activity);
            }
        }
        return sActivity != null ? (Activity)sActivity.get() : null;
    }

    private static Context getApplicationContext() {
        Activity activity;
        if ((sContext == null || sContext.get() == null) && (activity = GameAgent.getActivity()) != null) {
            sContext = new WeakReference<Context>(activity.getApplicationContext());
        }
        return sContext != null ? (Context)sContext.get() : null;
    }

    private static void runTaskInUiThread(Runnable runnable) {
        Activity activity = GameAgent.getActivity();
        if (activity != null) {
            activity.runOnUiThread(runnable);
        } else {
            new Thread(runnable).start();
        }
    }

    private static void exitApplication() {
        int n = Process.myPid();
        GameAgent.printLog(3, String.format(Locale.US, "Exit application by kill process[%d]", n));
        Process.killProcess((int)n);
    }

    private static void delayExit(long l) {
        l = Math.max(0L, l);
        if (sHandler != null) {
            sHandler.postDelayed(new Runnable(){

                @Override
                public void run() {
                    GameAgent.exitApplication();
                }
            }, l);
        } else {
            try {
                Thread.sleep(l);
                GameAgent.exitApplication();
            }
            catch (InterruptedException interruptedException) {
                interruptedException.printStackTrace();
            }
        }
    }

    private static String convertToCanonicalName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (sdkPackageName == null) {
            sdkPackageName = "com.tencent.bugly";
        }
        stringBuilder.append(sdkPackageName);
        stringBuilder.append(".");
        stringBuilder.append(string);
        return stringBuilder.toString();
    }

    public static void setSdkPackageName(String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        sdkPackageName = string;
    }

    public static void setGameType(int n) {
        sGameType = n;
    }

    public static void setLogEnable(boolean bl) {
        sIsDebug = bl;
    }

    private static Object newStrategy(Context context, String string, String string2, long l) {
        if (context == null || TextUtils.isEmpty((CharSequence)string) && TextUtils.isEmpty((CharSequence)string2)) {
            return null;
        }
        Object object = Reflection.newInstance(GameAgent.convertToCanonicalName(OLD_STRATEGY_CLASS_SUFFIX), new Object[]{context}, new Class[]{Context.class});
        if (object != null) {
            try {
                Class<?> clazz = Class.forName(GameAgent.convertToCanonicalName(STRATEGY_CLASS_SUFFIX));
                Method method = clazz.getDeclaredMethod("setAppChannel", String.class);
                method.invoke(object, string);
                Method method2 = clazz.getDeclaredMethod("setAppVersion", String.class);
                method2.invoke(object, string2);
                Method method3 = clazz.getDeclaredMethod("setAppReportDelay", Long.TYPE);
                method3.invoke(object, l);
                return object;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (IllegalArgumentException illegalArgumentException) {
                illegalArgumentException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return null;
    }

    public static void initCrashReport(String string, boolean bl) {
        GameAgent.setLogEnable(bl);
        GameAgent.initCrashReport(string, sAppChannel, sAppVersion, sUserId, 0L);
    }

    private static void initCrashReport(final String string, String string2, String string3, final String string4, long l) {
        final Context context = GameAgent.getApplicationContext();
        if (context == null) {
            GameAgent.printLog(4, "Context is null. bugly initialize terminated.");
            return;
        }
        if (TextUtils.isEmpty((CharSequence)string)) {
            GameAgent.printLog(4, "Please input appid when initCrashReport.");
            return;
        }
        sHandler = new Handler(Looper.getMainLooper());
        final Object object = GameAgent.newStrategy(context, string2, string3, l);
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                boolean bl = false;
                boolean bl2 = sIsDebug;
                if (object != null) {
                    Class<?> clazz = null;
                    try {
                        clazz = Class.forName(GameAgent.convertToCanonicalName(GameAgent.OLD_STRATEGY_CLASS_SUFFIX));
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        classNotFoundException.printStackTrace();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                    if (clazz != null) {
                        Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "initCrashReport", new Object[]{context, string, bl2, object}, new Class[]{Context.class, String.class, Boolean.TYPE, clazz});
                        bl = true;
                    }
                }
                if (!bl) {
                    Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "initCrashReport", new Object[]{context, string, bl2}, new Class[]{Context.class, String.class, Boolean.TYPE});
                }
                GameAgent.setUserId(string4);
            }
        });
    }

    public static void setAppVersion(final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        sAppVersion = string;
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "setAppVersion", new Object[]{GameAgent.getApplicationContext(), string}, new Class[]{Context.class, String.class});
            }
        });
    }

    public static void setAppChannel(final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        sAppChannel = string;
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "setAppChannel", new Object[]{GameAgent.getApplicationContext(), string}, new Class[]{Context.class, String.class});
            }
        });
    }

    public static void setUserId(final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        sUserId = string;
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "setUserId", new Object[]{GameAgent.getApplicationContext(), string}, new Class[]{Context.class, String.class});
            }
        });
    }

    public static void setUserSceneTag(final int n) {
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "setUserSceneTag", new Object[]{GameAgent.getApplicationContext(), n}, new Class[]{Context.class, Integer.TYPE});
            }
        });
    }

    public static void putUserData(final String string, final String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "putUserData", new Object[]{GameAgent.getApplicationContext(), string, string2}, new Class[]{Context.class, String.class, String.class});
            }
        });
    }

    public static void removeUserData(final String string) {
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "removeUserData", new Object[]{GameAgent.getApplicationContext(), string}, new Class[]{Context.class, String.class});
            }
        });
    }

    public static void setSdkConfig(final String string, final String string2) {
        if (TextUtils.isEmpty((CharSequence)string) || TextUtils.isEmpty((CharSequence)string2)) {
            return;
        }
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName(GameAgent.CRASH_REPORT_CLASS_SUFFIX), "putSdkData", new Object[]{GameAgent.getApplicationContext(), "SDK_" + string, string2}, new Class[]{Context.class, String.class, String.class});
            }
        });
    }

    public static void setLog(int n, final String string, final String string2) {
        String string3;
        if (TextUtils.isEmpty((CharSequence)string)) {
            return;
        }
        switch (n) {
            case 0: {
                string3 = "v";
                break;
            }
            case 1: {
                string3 = "d";
                break;
            }
            case 2: {
                string3 = "i";
                break;
            }
            case 3: {
                string3 = "w";
                break;
            }
            case 4: {
                string3 = "e";
                break;
            }
            default: {
                string3 = null;
            }
        }
        if (string3 != null) {
            GameAgent.runTaskInUiThread(new Runnable(){

                @Override
                public void run() {
                    Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName("crashreport.BuglyLog"), string3, new Object[]{string, string2}, new Class[]{String.class, String.class});
                }
            });
        }
    }

    private static void postCocosLuaException(final int n, String string, final String string2, String string3, final boolean bl) {
        String string4;
        block6: {
            try {
                int n2;
                if (string3.startsWith("stack traceback")) {
                    string3 = string3.substring(string3.indexOf("\n") + 1, string3.length()).trim();
                }
                if ((n2 = string3.indexOf("\n")) > 0) {
                    string3 = string3.substring(n2 + 1, string3.length());
                }
                n2 = string3.indexOf("\n");
                string4 = string3;
                if (n2 > 0) {
                    string4 = string3.substring(0, n2);
                }
                int n3 = string4.indexOf("]:");
                if (string == null || string.length() == 0) {
                    string = n3 != -1 ? string4.substring(0, n3 + 1) : string2;
                }
            }
            catch (Throwable throwable) {
                if (string != null && string.length() != 0) break block6;
                string = string2;
            }
        }
        final String string5 = string;
        string4 = string3;
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName("crashreport.inner.InnerApi"), "postCocos2dxCrashAsync", new Object[]{n, string5, string2, string4}, new Class[]{Integer.TYPE, String.class, String.class, String.class});
                if (bl) {
                    GameAgent.delayExit(3000L);
                }
            }
        });
    }

    private static void postCocosJsException(final int n, final String string, final String string2, final String string3, final boolean bl) {
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName("crashreport.inner.InnerApi"), "postCocos2dxCrashAsync", new Object[]{n, string, string2, string3}, new Class[]{Integer.TYPE, String.class, String.class, String.class});
                if (bl) {
                    GameAgent.delayExit(3000L);
                }
            }
        });
    }

    private static void postUnityException(final String string, final String string2, final String string3, final boolean bl) {
        GameAgent.runTaskInUiThread(new Runnable(){

            @Override
            public void run() {
                Reflection.invokeStaticMethod(GameAgent.convertToCanonicalName("crashreport.inner.InnerApi"), "postU3dCrashAsync", new Object[]{string, string2, string3}, new Class[]{String.class, String.class, String.class});
                if (bl) {
                    GameAgent.delayExit(3000L);
                }
            }
        });
    }

    public static void postException(int n, String string, String string2, String string3, boolean bl) {
        switch (n) {
            case 5: {
                GameAgent.postCocosJsException(n, string, string2, string3, bl);
                break;
            }
            case 6: {
                GameAgent.postCocosLuaException(n, string, string2, string3, bl);
                break;
            }
            case 4: {
                GameAgent.postUnityException(string, string2, string3, bl);
                break;
            }
            default: {
                GameAgent.printLog(4, "The category of exception posted is unknown: " + String.valueOf(n));
            }
        }
    }

    private static class Reflection {
        private Reflection() {
        }

        private static Object getStaticField(String string, String string2, Object object) {
            try {
                Class<?> clazz = Class.forName(string);
                Field field = clazz.getDeclaredField(string2);
                field.setAccessible(true);
                return field.get(object);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchFieldException noSuchFieldException) {
                noSuchFieldException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            return null;
        }

        private static Object invokeStaticMethod(String string, String string2, Object[] objectArray, Class<?> ... classArray) {
            try {
                Class<?> clazz = Class.forName(string);
                Method method = clazz.getDeclaredMethod(string2, classArray);
                method.setAccessible(true);
                return method.invoke(null, objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }

        private static Object newInstance(String string, Object[] objectArray, Class<?> ... classArray) {
            try {
                Class<?> clazz = Class.forName(string);
                if (objectArray == null) {
                    return clazz.newInstance();
                }
                Constructor<?> constructor = clazz.getConstructor(classArray);
                return constructor.newInstance(objectArray);
            }
            catch (ClassNotFoundException classNotFoundException) {
                classNotFoundException.printStackTrace();
            }
            catch (NoSuchMethodException noSuchMethodException) {
                noSuchMethodException.printStackTrace();
            }
            catch (InstantiationException instantiationException) {
                instantiationException.printStackTrace();
            }
            catch (IllegalAccessException illegalAccessException) {
                illegalAccessException.printStackTrace();
            }
            catch (InvocationTargetException invocationTargetException) {
                invocationTargetException.printStackTrace();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            return null;
        }
    }
}

